{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 05.09.98 - 21:47:57 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  StdCtrls,
  Dialogs,
  MMObj,
  MMDSPObj,
  MMCstDlg,
  MMRegs,
  MMWaveIO,
  MMAVI,
  MMWave,
  MMGauge;

type
  TSaveForm = class(TForm)
    WaveOpenDialog: TMMWaveOpenDialog;
    btnFile: TButton;
    WaveFile: TMMWaveFile;
    btnCompress: TButton;
    AVIFile: TMMAVIFile;
    AVICompressor: TMMAVICompressor;
    Gauge: TMMGauge;
    btnSave: TButton;
    AVISaveDialog: TMMAVISaveDialog;
    procedure btnFileClick(Sender: TObject);
    procedure btnCompressClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    Abort: Boolean;

    procedure SaveWavToAvi(Wave: TMMWave; FName: TFileName);
    procedure CompressWavToAvi(Wave: TMMWave; FName: TFileName);
  end;

var
  SaveForm: TSaveForm;

implementation

{$R *.DFM}

{ TODO: Initial Stream Description }

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Abort := True;
end;

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.btnFileClick(Sender: TObject);
begin
    if WaveOpenDialog.Execute then
    begin
        WaveFile.Wave.FileName := WaveOpenDialog.FileName;

        btnSave.Enabled := not WaveFile.Wave.Empty;
        btnCompress.Enabled := not WaveFile.Wave.Empty;
    end;
end;

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.btnSaveClick(Sender: TObject);
begin
    if AVISaveDialog.Execute then
       SaveWavToAvi(WaveFile.Wave, AVISaveDialog.FileName);
end;

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.btnCompressClick(Sender: TObject);
begin
    if AVISaveDialog.Execute then
       CompressWavToAvi(WaveFile.Wave, AVISaveDialog.FileName);
end;

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.SaveWavToAvi(Wave: TMMWave; FName: TFileName);
var
    AVIStream : TMMAVIStream;
    AVIWorker : TMMAVIAudioWorker;
    Buf : Pointer;
    Size: Longint;
    nBytes,Current: LongInt;

begin
   { set the AVI filename }
   AVIFile.FileName := FName;
   { create a new AVI file }
   AVIFile.CreateFile;
   try
      { create a new AVI-Audio stream }
      AVIStream := AVIFile.CreateAudioStream(Wave.PWaveFormat,'My Audio Stream');
      try
         { alloc a conversion buffer }
         Size := 32768;
         GetMem(Buf,Size);
         try
            { now create our object "Audio Worker" which does the streaming }
            AVIWorker := TMMAVIAudioWorker.Create(AVIStream);
            try
               { start writing to the stream }
               AVIWorker.BeginWriting(AVIStream.StartPos,Size);
               try
                  Current := 0;
                  { open the source Wave file }
                  Wave.OpenFile;
                  try
                     Abort := False;
                     { now start the loop }
                     repeat
                         { read some bytes from source }
                         nBytes := Wave.ReadDataBytes(Buf,Size);
                         { and write it to the AVI stream }
                         if nBytes >= 0 then
                            AVIWorker.WriteData(Buf,nBytes);

                         inc(Current,nBytes);
                         Gauge.Progress := Trunc(Current*100/Wave.DataSize);
                         Application.ProcessMessages;

                     until (nBytes <= 0) or Abort;

                  finally
                     { don't forget to close the Wave file }
                     Wave.CloseFile;
                  end;

               finally
                  { free all streaming resources ! }
                  AVIWorker.EndWriting;
               end;

            finally
               { release the helper object }
               AVIWorker.Free;
            end;

         finally
            { free the conversion buffer }
            FreeMem(Buf);
         end;

      finally
         { release the AVI stream, don't use Free, we use a reference counter internal }
         AVIStream.Release;
      end;

   finally
      { finaly close the file }
      AVIFile.CloseFile;
      Gauge.Progress := 0;
   end;
end;

{-- TSaveForm -----------------------------------------------------------------}
procedure TSaveForm.CompressWavToAvi(Wave: TMMWave; FName: TFileName);
var
    AVIStream : TMMAVIStream;
    AVIWorker : TMMAVIAudioWorker;
    Buf : PChar;
    Size: Longint;
    nBytes,Current: LongInt;

    S: TMMAVIStream;

begin
   { set the AVI filename }
   AVIFile.FileName := FName;
   { create a new AVI file }
   AVIFile.CreateFile;
   try
      { first we create a temporary AVI stream for format selection }
      S := AVICreateAudioStream(WaveFile.Wave.PWaveFormat);
      try
         { add the temp Audio stream to the compressor }
         AVICompressor.AddStream(S);
         try
            { choose the destination format for the stream }
            if AVICompressor.ChooseOptions then
            begin
               { create a new AVI-Audio stream with the selected format in the file }
               AVIStream := AVIFile.CreateAudioStream(AVICompressor.Options[0].lpFormat,'My Audio Stream');
               try
                  { now create our "Audio Worker" which does the compression }
                  AVIWorker := TMMAVIAudioWorker.CreateCompressed(AVIStream,WaveFile.Wave.PWaveFormat);
                  try
                     { alloc a conversion buffer }
                     Size := 32768;
                     GetMem(Buf,Size);
                     try
                        { start writing to the stream }
                        AVIWorker.BeginWriting(AVIStream.StartPos,Size);
                        try
                           Current := 0;
                           { open the source Wave file }
                           Wave.OpenFile;
                           try
                              Abort := False;
                              { now start the conversion loop }
                              repeat
                                 { read some bytes from source }
                                 nBytes := Wave.ReadDataBytes(Buf,Size);
                                 { and write it to the AVI stream }
                                 if nBytes >= 0 then
                                    AVIWorker.WriteData(Buf,nBytes);

                                 inc(Current,nBytes);
                                 Gauge.Progress := Trunc(Current*100/Wave.DataSize);
                                 Application.ProcessMessages;

                              until (nBytes <= 0) or Abort;

                           finally
                              { don't forget to close the Wave file }
                              Wave.CloseFile;
                           end;

                        finally
                           { free all conversion resources ! }
                           AVIWorker.EndWriting;
                        end;

                     finally
                        { free the conversion buffer }
                        FreeMem(Buf);
                     end;

                  finally
                     { release the "Audio Worker" }
                     AVIWorker.Free;
                  end;

               finally
                  { release the AVI stream, don't use Free, we use a reference counter internal }
                  AVIStream.Release;
               end;
            end;

         finally
            { remove all references to our stream so we an release it }
            AVICompressor.FreeStreams;
         end;

      finally
         { close our temporary stream }
         AVICloseStream(S);
      end;

   finally
      { finaly close the file }
      AVIFile.CloseFile;
      Gauge.Progress := 0;
   end;
end;

end.
